package gov.va.med.mhv.common.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "PATIENT_INFO")
public class PatientInformation extends AbstractBaseEntity {

	private static final long serialVersionUID = -3833108733685880261L;

	@Id
	@Column(name = "PATIENT_ID")
	private Long patientId;

	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;
	
	@Column(name = "ICN")
	private String icn;

	@Column(name = "FIRST_NAME")
	private String firstName;

	@Column(name = "MIDDLE_NAME")
	private String middleName;

	@Column(name = "LAST_NAME")
	private String lastName;

	@Column(name = "SUFFIX")
	private String suffix;

	@Column(name = "SSN")
	private String ssn;

	@Column(name = "EMAIL")
	private String email;

	@Column(name = "BIRTH_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date birthDate;

	@Column(name = "USER_NAME")
	private String userName;

	@Column(name = "MHV_ID")
	private String mhvId;

	@Column(name = "IPA_STATUS")
	private String ipaStatus;

	@Column(name = "IPA_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date ipaDate;

	@Column(name = "IPA_FACILITY_INFO_ID")
	private Long ipaFacilityInfoId;

	@Column(name = "IPA_FACILITY_INFO_NAME")
	private String ipaFacilityInfoName;

	@Column(name = "TREATING_FACILITY_ID")
	private Long treatingFacilityId;

	@Column(name = "CORRELATION_STATUS")
	private Integer correlationStatus;

	@Column(name = "GENDER")
	private String gender;

	@Column(name = "CORRELATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date correlatedDate;

	@Column(name = "MATCHED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date matchedDate;

	@Column(name = "MVI_AUTHENTICATION_STATUS")
	private String mviAuthenticationStatus;

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getMhvId() {
		return mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	public String getIpaStatus() {
		return ipaStatus;
	}

	public void setIpaStatus(String ipaStatus) {
		this.ipaStatus = ipaStatus;
	}

	public Date getIpaDate() {
		return ipaDate;
	}

	public void setIpaDate(Date ipaDate) {
		this.ipaDate = ipaDate;
	}

	public Long getIpaFacilityInfoId() {
		return ipaFacilityInfoId;
	}

	public void setIpaFacilityInfoId(Long ipaFacilityInfoId) {
		this.ipaFacilityInfoId = ipaFacilityInfoId;
	}

	public String getIpaFacilityInfoName() {
		return ipaFacilityInfoName;
	}

	public void setIpaFacilityInfoName(String ipaFacilityInfoName) {
		this.ipaFacilityInfoName = ipaFacilityInfoName;
	}

	public Long getTreatingFacilityId() {
		return treatingFacilityId;
	}

	public void setTreatingFacilityId(Long treatingFacilityId) {
		this.treatingFacilityId = treatingFacilityId;
	}

	public Integer getCorrelationStatus() {
		return correlationStatus;
	}

	public void setCorrelationStatus(Integer correlationStatus) {
		this.correlationStatus = correlationStatus;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public Date getCorrelatedDate() {
		return correlatedDate;
	}

	public void setCorrelatedDate(Date correlatedDate) {
		this.correlatedDate = correlatedDate;
	}

	public Date getMatchedDate() {
		return matchedDate;
	}

	public void setMatchedDate(Date matchedDate) {
		this.matchedDate = matchedDate;
	}

	public String getMviAuthenticationStatus() {
		return mviAuthenticationStatus;
	}

	public void setMviAuthenticationStatus(String mviAuthenticationStatus) {
		this.mviAuthenticationStatus = mviAuthenticationStatus;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
		
}
